program karstfor        
!Set values for initial store volumes, fluxes, isotope composition and cave temperature. 
integer :: TT
real :: T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, MEANT
real :: EVPT1, EVPT2, EVPT3, PTXSTORXP, EPX18O, EPX18OXP
real :: TEMPPXP, EPXSTORXP, EPXSTOR, PTXSTORD18OXP 
real :: DRIP18O, DRIP118O, DRIP218O, N
real :: STALD18OK, STAL1D18OK, STAL2D18OK, STAL3D18OK
real :: D18OXP, OVCAP, K, L, M
EVPT1=0.
EVPT2=0.
EVPT3=0.
N=0.
TT=0
PTXSTORXP=20000.
EPX18O=-6.
EPX18OXP=-6.
TEMPPXP=0.
EPXSTORXP=2000.
EPXSTOR=22000.
PTXSTORD18OXP=-6.
T1=10.
T2=10.
T3=10.
T4=10.
T5=10.
T6=10.
T7=10.
T8=10.
T9=10.
T10=10.
T11=10.
MEANT=10.
DRIP18O=-6.
OVCAP=3000.
OVFLOWD18OXP=-6.
OVFLOWD18O=-6.
DRIP218O=-6.
D18OXP=-6.
P=-6.
R=-6.
STALD18OK=-6.
STAL1D18OK=-6.
STAL2D18OK=-6.
STAL3D18OK=-6.	
open (unit=5,file='INPUT.PRN',status='OLD')
open (unit=6,file='OUTPUT.DAT',status='NEW')   
!Reads the input file, which has the format 'number, month(1-12), PET, P, T, 18O.  
25 read(unit=5,fmt="(I8, I8, 4F8.1)")TT,MM,EVPT,PRP,TEMPP,D18O
if (PTXSTORXP+PRP-EVPT.LT.0) then
EVPT=0
else    
PTXSTOR=PTXSTORXP+PRP-EVPT
end if
!Generate a flux from peat to epikarst only autumn and when SMD is declining 
if (EVPT.GT.EVPT1) then
F1=0
elseif (EVPT1.GT.EVPT2)then
F1=0
elseif(EVPT2.LT.EVPT3) then
F1=0
elseif (MM.LT.7) then
F1=0
elseif(MM.GT.11) then
F1=0               
elseif(N.LT.5) then
F1=0
else
F1=PTXSTOR*0.1
P=D18O
R=D18OXP
N=0
endif
if(N.GT.13) then
F1=(PTXSTOR-PRP)*0.1
N=0
else
goto 45
endif
! Generates a flux when peat freezes. In this case, 0.4 degree C 
! is parameterised to fit observed fluxes.  
45 if(TEMPP.LT.0.4) then
if(T11.LT.0.4) then
F2=PTXSTOR*0.1
P=D18O
R=D18OXP
else     
F2=0
endif    
else 
F2=0
endif
!Increases eipkarst store volume and generate overflow      
EPXSTOR=EPXSTORXP+F1+F2
if(EPXSTOR.GT.2500) then
F4=EPXSTOR-2500
else
F4=0
endif     
! 0.08 term parameterised to maintain continuous F3 flux 
F3=(EPXSTOR-F4)*0.08
PTXSTOR=PTXSTOR-F1-F2
EPXSTOR=EPXSTOR-F3-F4                
E=PRP+PTXSTORXP     
if(E.LT.0.01)then
E=0.001
else
E=PRP+PTXSTORXP
end if
F=PTXSTORXP/E
G=PRP/E   
! 0.00 term can be changed to enable evaporative fractionation in soil store 
H=D18O+(EVPT*0.00)
PTXSTORD18O=(F*PTXSTORD18OXP)+(G*H)  
if(PTXSTORD18O.GT.0.0001)then
PTXSTORD18O=PTXSTORD18OXP
endif
A=F1+F2
B=A+EPXSTORXP
C=(EPXSTORXP/B)*EPX18OXP
D=(A/B)*PTXSTORD18O
EPX18O=C+D
DRIP18O=EPX18O
DRIP118O=(EPX18O*0.50)+(P*.25)+(R*.25)
DRIP218O=(EPX18O*0.75)+(P*0.25)
if(F4.LT.0.1) then
OVFLOWD18O=OVFLOWD18OXP
goto 60
endif 
K=(OVCAP-F4)/3000
L=K*OVFLOWD18OXP
M=(F4/OVCAP)*EPX18O
OVFLOWD18O=L+M
! Caculates temperature dependent fractionation using Kim and O'Niell. Other equations
! can be used. Also, monthly T averaging will be site specific. For example, change to
! MEANT+(T1+T2+T3+....TEMPP)/12 for annual mean cave air T. 
60 MEANT=(T6+T7+T8+T9+T10+T11+TEMPP)/7
STALD18OK=DRIP18O+3.152+(-0.233*MEANT)
STAL2D18OK=DRIP118O+3.152+(-0.233*MEANT)
STAL3D18OK=DRIP218O+3.152+(-0.233*MEANT)
STAL1D18OK=OVFLOWD18O+3.152+(-0.233*MEANT)
! Output data for this timestep and update model terms
write(unit=6,fmt="(2I5, 8F12.3)")TT,MM,EPX18O,F1,PTXSTOR,EPXSTOR,STALD18OK,STAL1D18OK,STAL2D18OK,STAL3D18OK 
EVPT3=EVPT2
EVPT2=EVPT1
EVPT1=EVPT                                 
T1=T2
T2=T3
T3=T4
T4=T5
T5=T6
T6=T7
T7=T8
T8=T9
T9=T10
T10=T11
T11=TEMPP
EPX18OXP=EPX18O
EPXSTORXP=EPXSTOR
PTXSTORXP=PTXSTOR
PTXSTORD18OXP=PTXSTORD18O
D18OXP=D18O
OVFLOWD18OXP=OVFLOWD18O
N=N+1
! End of file after 12000 months (1000 years) 
if (TT==11999) then
endfile(5)
else
goto 25              
endif
end karstfor
